#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef double ld;

#define sz(x) ((int) (x).size())
#define pb push_back
#define mp make_pair
#define fi first
#define se second

#define NAME "e"

struct circle
{
	int x, r;
	
	bool operator<(const circle &a) const
	{
		return x + r < a.x + a.r;
	}
	
};

bool inside(circle &a, circle &b)
{
	return b.x - b.r <= a.x - a.r && b.x + b.r >= a.x + a.r;
}

bool not_intersect(circle &a, circle &b)
{
	return a.x + a.r <= b.x - b.r || a.x - a.r >= b.x + b.r;
}

circle a[100001];
vector <circle> o;
int n;

ld get_cos(circle &a, circle &b)
{
	ld r1 = a.r;
	ld r2 = b.r;
	ld d = abs(b.x - a.x);
	return (r1 * r1 - r2 * r2 + d * d) / (2 * r1 * d);
}

vector <pair <ld, int> > q;

bool check_ans(ld h)
{
//	cerr << "check " << h << '\n';
	q.clear();
	for (int i = 0; i < n; ++i)
	{
		if (a[i].r < h)
			continue;
		ld ch = sqrtl(ld(a[i].r) * ld(a[i].r) - h * h) + 1e-10;
		q.pb(mp(a[i].x - ch, -1));
		q.pb(mp(a[i].x + ch, 1));
	}
	sort(q.begin(), q.end());
	if (q.empty())
		return false;
	ld pr = q[0].fi;
	int sum = 0;
	for (int i = 0; i < sz(q); ++i)
	{
		if (sum == 0)
			pr = q[i].fi;
		if (q[i].fi - pr >= 2 * h)
			return true;
		sum += q[i].se;
	}
	return false;
}

bool solve()
{
	cin >> n;
	if (!n)
		return false;
	for (int i = 0; i < n; ++i)
	{
		int x, r;
		scanf("%d%d", &x, &r);
		a[i].x = x, a[i].r = r;
	}
	sort(a, a + n);
	o.clear();
	for (int i = 0; i < n; ++i)
	{
		circle c = a[i];
		bool ok = true;
		while (!o.empty())
		{
			if (inside(c, o.back()))
			{
				ok = false;
				break;
			}
			if (inside(o.back(), c))
			{
				o.pop_back();
				continue;
			}
			if (not_intersect(o.back(), c))
				break;
			if (o.size() == 1)
				break;
			circle v = o[o.size() - 2];
			if (not_intersect(v, c))
				break;
			ld cosa = get_cos(o.back(), c);
			ld cosb = get_cos(o.back(), v);
			if (cosa < cosb)
			{
				o.pop_back();
				continue;
			}
			break;
		}
		if (ok)
			o.pb(c);
	}
	ld ans = 0.0;
	for (int i = 0; i < sz(o) - 1; ++i)
	{
		if (not_intersect(o[i], o[i + 1]))
			continue;
		ld cosa = get_cos(o[i], o[i + 1]);
		ld h = ld(o[i].r) * sqrtl(ld(1) - cosa * cosa);
		if (check_ans(h))
			ans = max(2 * h, ans);
	}
	for (int i = 0; i < n; ++i)
		ans = max(ans, ld(a[i].r) * sqrt(2));
	cout << ans << '\n';
	return true;
}

int main()
{
	cout.precision(10);
	cout.setf(ios::fixed);
	#ifdef LOCAL
	assert(freopen(NAME ".in", "r", stdin));
	#endif // LOCAL
	while (solve());
	#ifdef LOCAL
	cerr << "Time: " << double(clock()) / CLOCKS_PER_SEC << "\n";
	#endif // LOCAL
	return 0;
}
